//Maya ASCII 4.0 scene
//Name: denfo-07.ma
//Last modified: Tue, Dec 18, 2001 06:00:02 PM
requires maya "4.0";
currentUnit -l centimeter -a degree -t film;
createNode expression -n "cellExpression_3";
	setAttr -k on ".nds";
	setAttr -s 62 ".in";
	setAttr -s 62 ".in";
	setAttr -s 6 ".out";
	setAttr ".ixp" -type "string" (
		"// -------------------------------------------------------------\r\n"
		+ "//\tcellShader expression v2.0\r\n"
		+ "//\r\n"
		+ "//\tDeveloped by Martin Leguizamon, Argentina\r\n"
		+ "//\t\377 Copyright 2001 Martin Leguizamon\r\n"
		+ "//\r\n"
		+ "//\thttp://www.geocities.com/provide3d\r\n"
		+ "//\tlaupamar@satlink.com / provide3d@yahoo.com  \r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Declarations\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "vector $a;\t\t// RGB vector \r\n"
		+ "vector $b;\t\t// HSV vector \r\n"
		+ "vector $O;\t\t// RGB out color \r\n"
		+ "vector $CB;\t\t// Border color \r\n"
		+ "\r\n"
		+ "float $b0;\t\t// H component \r\n"
		+ "float $b1;\t\t// S component \r\n"
		+ "float $b2;\t\t// V component \r\n"
		+ "float $f1;\t\t// Value stagger \r\n"
		+ "float $f2;\t\t// Saturation stagger \r\n"
		+ "float $f3;\t\t// Hue stagger \r\n"
		+ "float $s1;\t\t// Step value and saturation \r\n"
		+ "float $s2;\t\t// Step Hue \r\n"
		+ "int $is1;\t\t// Integer step 1 \r\n"
		+ "int $is2;\t\t// Integer step 2 \r\n"
		+ "float $d;\t\t// Facing ratio \r\n"
		+ "float $rc1;\t\t// Random value a \r\n"
		+ "float $rc2;\t\t// Random value b \r\n"
		+ "float $rc3;\t\t// Random value c \r\n"
		+ "float $rc4;\t\t// Random value d \r\n"
		+ "float $cbu0;\t\t// U udge border color (R component) \r\n"
		+ "float $cbu1;\t\t// U edge border color (R component) \r\n"
		+ "float $cbu2;\t\t// U edge border color (R component) \r\n"
		+ "float $cbv0;\t\t// V edge border color (R component) \r\n"
		+ "float $cbv1;\t\t// V edge border color (R component) \r\n"
		+ "float $cbv2;\t\t// V edge border color (R component) \r\n"
		+ "float $x1;\t\t// Input smooth fade function a \r\n"
		+ "float $x2; \t\t// Input smooth fade function b \r\n"
		+ "float $y1;\t\t// Output smooth fade function a \r\n"
		+ "float $y2;\t\t// Output smooth fade function b \r\n"
		+ "float $exp;\t\t// Exponencial gradient index \r\n"
		+ "float $fed;\t\t// Output difuse facing edge \r\n"
		+ "float $ued;\t\t// Output difuse U edge \r\n"
		+ "float $ved;\t\t// Output difuse V edge \r\n"
		+ "float $gdu;\t\t// Difuse U edge \r\n"
		+ "float $gdv;\t\t// Difuse V edge \r\n"
		+ "float $nsou;\t\t// Out noise U \r\n"
		+ "float $nsov;\t\t// Out noise V \r\n"
		+ "float $uvug;\t\t// Grain U \r\n"
		+ "float $uvvg;\t\t// Grain V \r\n"
		+ "float $cm0;\t\t// Mask (R component) \r\n"
		+ "float $cm1;\t\t// Mask (G component) \r\n"
		+ "float $cm2;\t\t// Mask (B component) \r\n"
		+ "float $cmu0;\t\t// Mask U (R component) \r\n"
		+ "float $cmu1;\t\t// Mask U (G component) \r\n"
		+ "float $cmu2;\t\t// Mask U (B component) \r\n"
		+ "float $cmv0;\t\t// Mask V (R component) \r\n"
		+ "float $cmv1;\t\t// Mask V (G component) \r\n"
		+ "float $cmv2;\t\t// Mask V (B component) \r\n"
		+ "\r\n"
		+ "float $dfc;\t\t// H out temporal \r\n"
		+ "float $dfl0;\t\t// S out temporal \r\n"
		+ "float $dfl1;\t\t// V out temporal \r\n"
		+ "float $uvut;\t\t// U out value temporal \r\n"
		+ "float $uvvt;\t\t// V out value temporal \r\n"
		+ "float $edu;\t\t// U value temporal \r\n"
		+ "float $edv;\t\t// V value temporal \r\n"
		+ "\r\n"
		+ "float $o0;\t\t// Out color (R component) \r\n"
		+ "float $o1;\t\t// Out color (G component) \r\n"
		+ "float $o2;\t\t// Out color (B component) \r\n"
		+ "float $om0;\t\t// Out mask (R component) \r\n"
		+ "float $om1;\t\t// Out mask (G component) \r\n"
		+ "float $om2;\t\t// Out mask (B component) \r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Links imageData node\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "$uvu=\t.I[0];\r\n"
		+ "$uvv=\t.I[1];\r\n"
		+ "$fpn=\t.I[2];\r\n"
		+ "$d=\t.I[3];\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Links input node\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "$a0= \t.I[4];\r\n"
		+ "$a1= \t.I[5];\r\n"
		+ "$a2= \t.I[6];\r\n"
		+ "$ot0=\t.I[7];\r\n"
		+ "$ot1=\t.I[8];\r\n"
		+ "$ot2=\t.I[9];\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Links cellShader node\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "$s2=\t.I[10];\r\n"
		+ "$s1=\t.I[11];\r\n"
		+ "$cb0=\t.I[12];\r\n"
		+ "$cb1=\t.I[13];\r\n"
		+ "$cb2=\t.I[14];\r\n"
		+ "$sd=\t.I[15];\r\n"
		+ "$fev=\t.I[16];\r\n"
		+ "$uev=\t.I[17];\r\n"
		+ "$vev=\t.I[18];\r\n"
		+ "$bds=\t.I[19];\r\n"
		+ "$rbs=\t.I[20];\r\n"
		+ "$vec=\t.I[21];\r\n"
		+ "$uec=\t.I[22];\r\n"
		+ "$bdb=\t.I[23];\r\n"
		+ "$ueo=\t.I[24];\r\n"
		+ "$veo=\t.I[25];\r\n"
		+ "$bsc=\t.I[26];\r\n"
		+ "$bsl=\t.I[27];\r\n"
		+ "$feb=\t.I[28];\r\n"
		+ "$ueb=\t.I[29];\r\n"
		+ "$veb=\t.I[30];\r\n"
		+ "$uef=\t.I[31];\r\n"
		+ "$vef=\t.I[32];\r\n"
		+ "$smf=\t.I[33];\r\n"
		+ "$fse=\t.I[34];\r\n"
		+ "$fee=\t.I[35];\r\n"
		+ "$bt=\t.I[36];\r\n"
		+ "$uet=\t.I[37];\r\n"
		+ "$vet=\t.I[38];\r\n"
		+ "$adt=\t.I[39];\r\n"
		+ "$nsc=\t.I[40];\r\n"
		+ "$nsl=\t.I[41];\r\n"
		+ "$nsv=\t.I[42];\r\n"
		+ "$nsf=\t.I[43];\r\n"
		+ "$nsr=\t.I[44];\r\n"
		+ "$cn=\t.I[45];\r\n"
		+ "$ln=\t.I[46];\r\n"
		+ "$rb=\t.I[47];\r\n"
		+ "$gi=\t.I[48];\r\n"
		+ "$go=\t.I[49];\r\n"
		+ "$cdd=\t.I[50];\r\n"
		+ "$ldd=\t.I[51];\r\n"
		+ "$gd=\t.I[52];\r\n"
		+ "$bdi=\t.I[53];\r\n"
		+ "$bdo=\t.I[54];\r\n"
		+ "$ds=\t.I[55];\r\n"
		+ "$bgt=\t.I[56];\r\n"
		+ "$ctr=\t.I[57];\r\n"
		+ "$ap=\t.I[58];\r\n"
		+ "$ppb=\t.I[59];\r\n"
		+ "$omg=\t.I[60];\r\n"
		+ "$opm=\t.I[61];\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Input / color + luminance process\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Storing temporal values\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "\t$uvut=$uvu;\r\n"
		+ "\t$uvvt=$uvv;\r\n"
		+ "\t$gdu=$gd;\r\n"
		+ "\t$gdv=$gd;\r\n"
		+ "\t$exp=2;\r\n"
		+ "\t$om0=$ot0;\r\n"
		+ "\t$om1=$ot1;\r\n"
		+ "\t$om2=$ot2;\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Float step conversion\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "\t$is1=int($s1);\r\n"
		+ "\t$s1=int($is1);\r\n"
		+ "\t$is2=int($s2);\r\n"
		+ "\t$s2=int($is2);\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// RGB -> HSV conversion\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "\t$a=<<$a0,$a1,$a2>>;\r\n"
		+ "\r\n"
		+ "\t$b=rgb_to_hsv($a);\r\n"
		+ "\r\n"
		+ "\t$b0=$b * <<1,0,0>>;\r\n"
		+ "\t$b1=$b * <<0,1,0>>;\r\n"
		+ "\t$b2=$b * <<0,0,1>>;\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Color + luminance bias\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($bsc!=0.5)\r\n"
		+ "\t{ \r\n"
		+ "\t$b0=pow($b0,($bsc+0.5));\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($bsl!=0.5)\r\n"
		+ "\t{\r\n"
		+ "\t$b1=pow($b1,($bsl+0.5));\r\n"
		+ "\t$b2=pow($b2,($bsl+0.5));\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Color + luminance storing\r\n"
		+ "//\r\n"
		+ "\t$dfc=$b0;\r\n"
		+ "\t$dfl0=$b1;\r\n"
		+ "\t$dfl1=$b2;\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Noise rotation\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($nsr>=0 && $nsr<90)\r\n"
		+ "\t{\r\n"
		+ "\t$uvu=$uvu;\r\n"
		+ "\t$uvv=$uvv;\r\n"
		+ "\t$nsr=$nsr/90;\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($nsr>=90 && $nsr<=180)\r\n"
		+ "\t{\r\n"
		+ "\t$uvu=-$uvu;\r\n"
		+ "\t$uvv=$uvv;\r\n"
		+ "\t$nsr=1-(($nsr-90)/90);\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// HSV grain generation\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($cn>0)\r\n"
		+ "\t{\r\n"
		+ "\t$b0=$b0+(($cn/10)*(noise($uvu*20000)+1)*0.5);\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($ln>0)\r\n"
		+ "\t{\r\n"
		+ "\t$b1=$b1+(($ln/4)*(noise($uvu*20000)+1)*0.5);\r\n"
		+ "\t$b2=$b2+(($ln/4)*(noise($uvu*20000)+1)*0.5);\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// HSV noise generation\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($nsc>0)\r\n"
		+ "\t{\r\n"
		+ "\t$b0=$b0+(($nsc/10)*noise((($uvu*$nsr)+\r\n"
		+ "\t($uvv*(1-$nsr)))*(($nsf+0.05)*500)));\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($nsl>0)\r\n"
		+ "\t{\r\n"
		+ "\tif ($b1<(1-(1/($s1+1))))\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$b1=$b1+(($nsl/10)*noise((($uvu*$nsr)+\r\n"
		+ "\t\t($uvv*(1-$nsr)))*(($nsf+0.05)*500)));\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\tif ($b2<(1-(1/($s1+1))))\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$b2=$b2+(($nsl/10)*noise((($uvu*$nsr)+\r\n"
		+ "\t\t($uvv*(1-$nsr)))*(($nsf+0.05)*500)));\r\n"
		+ "\t\t}\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Value staggering\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($s1>0)\r\n"
		+ "\t{\r\n"
		+ "\tif ($s1==1)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$b2=1.0;\r\n"
		+ "\t\t}\r\n"
		+ "\telse\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$s1=1.0/$s1;\r\n"
		+ "\r\n"
		+ "\t\tfor ($f1=0;$f1<1;$f1+=$s1)\r\n"
		+ "\t\t\t{\r\n"
		+ "\t\t\tif ($b2>=($f1) && $b2<($f1+$s1))\r\n"
		+ "\t\t\t\t{\r\n"
		+ "\t\t\t\t$b2=$f1;\r\n"
		+ "\t\t\t\tbreak;\r\n"
		+ "\t\t\t\t}\r\n"
		+ "\t\t\t}\r\n"
		+ "\t\t}\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Saturation staggering\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($s1>0)\r\n"
		+ "\t{\r\n"
		+ "\tfor ($f2=0;$f2<1;$f2=$f2+$s1)\r\n"
		+ "\t\t{\r\n"
		+ "\t\tif ($b1>=($f2) && $b1<($f2+$s1))\r\n"
		+ "\t\t\t{\r\n"
		+ "\t\t\t$b1=$f2;\r\n"
		+ "\t\t\tbreak;\r\n"
		+ "\t\t\t}\r\n"
		+ "\t\t}\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Hue staggering\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($s2>0)\r\n"
		+ "\t{\r\n"
		+ "\t$s2=1/$s2;\r\n"
		+ "\r\n"
		+ "\tfor ($f3=0;$f3<1;$f3=$f3+$s2)\r\n"
		+ "\t\t{\r\n"
		+ "\t\tif ($b0>=($f3) && $b0<($f3+$s2))\r\n"
		+ "\t\t\t{\r\n"
		+ "\t\t\t$b0=$f3;\r\n"
		+ "\t\t\tbreak;\r\n"
		+ "\t\t\t}\r\n"
		+ "\t\t}\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Color + luminance step blend\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($cdd>0)\r\n"
		+ "\t{\r\n"
		+ "\t$b0=$b0*(1-$cdd)+($dfc*$cdd);\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($ldd>0)\r\n"
		+ "\t{\r\n"
		+ "\t$b1=$b1*(1-$ldd)+($dfl0*$ldd);\r\n"
		+ "\t$b2=$b2*(1-$ldd)+($dfl1*$ldd);\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Postprocess / saturation\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($ppb==0 && $ds>0)\r\n"
		+ "\t{\r\n"
		+ "\tif ($b1>0.5)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$b1=1-0.5*pow(2*(1-$b1),pow($ds+1,3));\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\tif ($b2>0.5)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$b2=1-0.5*pow(2*(1-$b2),pow($ds+1,3));\r\n"
		+ "\t\t}\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($ppb==0 && $ds<0)\r\n"
		+ "\t{\r\n"
		+ "\t$b1=$b1+$ds;\r\n"
		+ "\t$b1=clamp(0,1,$b1);\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Postprocess / soft colors\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($ppb==0 && $ap==1)\r\n"
		+ "\t{\r\n"
		+ "\t$b1=clamp(0,0.5,$b1);\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// HSV -> RGB conversion\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "\t$b=<<$b0,$b1,$b2>>;\r\n"
		+ "\r\n"
		+ "\t$O=hsv_to_rgb($b);\r\n"
		+ "\r\n"
		+ "\t$o0=$O * <<1,0,0>>;\r\n"
		+ "\t$o1=$O * <<0,1,0>>;\r\n"
		+ "\t$o2=$O * <<0,0,1>>;\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Postprocess / brightness\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($ppb==0 && $bgt!=0)\r\n"
		+ "\t{\r\n"
		+ "\t$o0=$o0+($bgt*0.5);\r\n"
		+ "\t$o1=$o1+($bgt*0.5);\r\n"
		+ "\t$o2=$o2+($bgt*0.5);\r\n"
		+ "\r\n"
		+ "\t$o0=clamp(0,1,$o0);\r\n"
		+ "\t$o1=clamp(0,1,$o1);\r\n"
		+ "\t$o2=clamp(0,1,$o2);\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Postprocess / contrast\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($ppb==0 && $ctr!=0)\r\n"
		+ "\t{\r\n"
		+ "\tif ($o0<0.5) \r\n"
		+ "\t\t{\r\n"
		+ "\t\t$o0=0.5*pow(2*$o0,pow($ctr+1,2)); \r\n"
		+ "\t\t}\r\n"
		+ "\telse \r\n"
		+ "\t\t{\r\n"
		+ "\t\t$o0=1-0.5*pow(2*(1-$o0),pow($ctr+1,2));\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\tif ($o1<0.5)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$o1=0.5*pow(2*$o1,pow($ctr+1,2));\r\n"
		+ "\t\t}\r\n"
		+ "\telse\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$o1=1-0.5*pow(2*(1-$o1),pow($ctr+1,2));\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\tif ($o2<0.5)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$o2=0.5*pow(2*$o2,pow($ctr+1,2));\r\n"
		+ "\t\t}\r\n"
		+ "\telse\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$o2=1-0.5*pow(2*(1-$o2),pow($ctr+1,2)); \r\n"
		+ "\t\t}\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Borders generation process / facing edge\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// U and V edges color + non additive transparency + mask\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "\t$cbu0=$cb0;\r\n"
		+ "\t$cbu1=$cb1;\r\n"
		+ "\t$cbu2=$cb2;\r\n"
		+ "\r\n"
		+ "\t$cbv0=$cb0;\r\n"
		+ "\t$cbv1=$cb1;\r\n"
		+ "\t$cbv2=$cb2;\r\n"
		+ "\t\r\n"
		+ "\t$cm0=1;\r\n"
		+ "\t$cm1=1;\r\n"
		+ "\t$cm2=1;\r\n"
		+ "\r\n"
		+ "\t$cmu0=$cm0;\r\n"
		+ "\t$cmu1=$cm1;\r\n"
		+ "\t$cmu2=$cm2;\r\n"
		+ "\r\n"
		+ "\t$cmv0=$cm0;\r\n"
		+ "\t$cmv1=$cm1;\r\n"
		+ "\t$cmv2=$cm2;\r\n"
		+ "\r\n"
		+ "if ($adt==0)\r\n"
		+ "\t{\r\n"
		+ "\t$cbu0=$cbu0*(1-$uet)+$o0*$uet;\r\n"
		+ "\t$cbu1=$cbu1*(1-$uet)+$o1*$uet;\r\n"
		+ "\t$cbu2=$cbu2*(1-$uet)+$o2*$uet;\r\n"
		+ "\r\n"
		+ "\t$cmu0=$cmu0*(1-$uet)+$om0*$uet;\r\n"
		+ "\t$cmu1=$cmu1*(1-$uet)+$om1*$uet;\r\n"
		+ "\t$cmu2=$cmu2*(1-$uet)+$om2*$uet;\r\n"
		+ "\r\n"
		+ "\t$cbv0=$cbv0*(1-$vet)+$o0*$vet;\r\n"
		+ "\t$cbv1=$cbv1*(1-$vet)+$o1*$vet;\r\n"
		+ "\t$cbv2=$cbv2*(1-$vet)+$o2*$vet;\r\n"
		+ "\r\n"
		+ "\t$cmv0=$cmv0*(1-$vet)+$om0*$vet;\r\n"
		+ "\t$cmv1=$cmv1*(1-$vet)+$om1*$vet;\r\n"
		+ "\t$cmv2=$cmv2*(1-$vet)+$om2*$vet;\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Edges visibility gain ( All edges )\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "\t$fev=$sd*$fev;\r\n"
		+ "\t$uev=$sd*$uev*0.5;\t\r\n"
		+ "\t$vev=$sd*$vev*0.5;\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Facing edge bias\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($feb<0.5)\r\n"
		+ "\t{\r\n"
		+ "\tif ($d>=0 && $d<1-($feb*2))\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$fev=0;\r\n"
		+ "\t\t}\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($feb>0.5)\r\n"
		+ "\t{\r\n"
		+ "\tif ($d>1-(($feb-0.5)*2) && $d<=1)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$fev=0;\r\n"
		+ "\t\t}\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Facing edge border grain\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($rb>0)\r\n"
		+ "\t{\r\n"
		+ "\t$rc1=$go *($rb*1.5*(noise($uvu*20000)+1));\r\n"
		+ "\t$rc2=$gi *($rb*0.5*(noise($uvu*20000)+1));\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "else\r\n"
		+ "\t{\r\n"
		+ "\t$rc1=0;\r\n"
		+ "\t$rc2=0;\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Facing edge border transparency + mask\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "\t$cb0=$cb0*(1-$bt)+$o0*$bt;\r\n"
		+ "\t$cb1=$cb1*(1-$bt)+$o1*$bt;\r\n"
		+ "\t$cb2=$cb2*(1-$bt)+$o2*$bt;\r\n"
		+ "\r\n"
		+ "\t$cm0=$cm0*(1-$bt)+$om0*$bt;\r\n"
		+ "\t$cm1=$cm1*(1-$bt)+$om1*$bt;\r\n"
		+ "\t$cm2=$cm2*(1-$bt)+$om2*$bt;\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Facing edge border offset\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "\t$d=$d-$bdb;\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Facing edge border noise generation\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($nsv>0 && $fev!=0) \r\n"
		+ "\t{\t\t\r\n"
		+ "\t$fev=$fev+(($nsv*$fev)*noise((($uvu*$nsr)+\r\n"
		+ "\t($uvv*(1-$nsr)))*(($nsf+0.05)*500)));\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Facing edge side control\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($bds==0)\r\n"
		+ "\t{\r\n"
		+ "\tif ($rbs==1)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$fev=$fev*$fpn;\r\n"
		+ "\t\t}\r\n"
		+ "\telse\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$fev=$fev*(1-$fpn);\r\n"
		+ "\t\t}\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Facing edge border difuse + draw + mask\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($d>=0+($rc1*$fev/4) && $d<$fev-($rc2*$fev/4))\r\n"
		+ "\t{\r\n"
		+ "\t$gd=($gd/4)*$fev;\r\n"
		+ "\r\n"
		+ "\tif ($d>$fev-$gd && $d<$fev && $bdi==1 && $gd>0) \r\n"
		+ "\t\t{\r\n"
		+ "\t\t$fed=pow(1-(($d-($fev-$gd))*(1/$gd)),$exp);\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\telse if ($d>=0 && $d<($gd*3) && $bdo==1 && $gd>0)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$fed=pow(($d*(1/($gd*3))),$exp);\r\n"
		+ "\t\t}\r\n"
		+ "\telse\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$fed=1;\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\t$o0=$o0*(1-$fed)+$cb0*$fed;\r\n"
		+ "\t$o1=$o1*(1-$fed)+$cb1*$fed;\r\n"
		+ "\t$o2=$o2*(1-$fed)+$cb2*$fed;\r\n"
		+ "\r\n"
		+ "\t$om0=$om0*(1-$fed)+$cm0*$fed;\r\n"
		+ "\t$om1=$om1*(1-$fed)+$cm1*$fed;\r\n"
		+ "\t$om2=$om2*(1-$fed)+$cm2*$fed;\r\n"
		+ "\r\n"
		+ "\tif ($adt==0 && $uet>$bt)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$cbu0=$cb0*$fed+$cbu0*(1-$fed);\r\n"
		+ "\t\t$cbu1=$cb1*$fed+$cbu1*(1-$fed);\r\n"
		+ "\t\t$cbu2=$cb2*$fed+$cbu2*(1-$fed);\r\n"
		+ "\r\n"
		+ "\t\t$cmu0=$cm0*$fed+$cmu0*(1-$fed);\r\n"
		+ "\t\t$cmu1=$cm1*$fed+$cmu1*(1-$fed);\r\n"
		+ "\t\t$cmu2=$cm2*$fed+$cmu2*(1-$fed);\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\tif ($adt==0 && $vet>$bt)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$cbv0=$cb0*$fed+$cbv0*(1-$fed);\r\n"
		+ "\t\t$cbv1=$cb1*$fed+$cbv1*(1-$fed);\r\n"
		+ "\t\t$cbv2=$cb2*$fed+$cbv2*(1-$fed);\r\n"
		+ "\r\n"
		+ "\t\t$cmv0=$cm0*$fed+$cmv0*(1-$fed);\r\n"
		+ "\t\t$cmv1=$cm1*$fed+$cmv1*(1-$fed);\r\n"
		+ "\t\t$cmv2=$cm2*$fed+$cmv2*(1-$fed);\r\n"
		+ "\t\t}\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Borders generation process / U and V edges\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// U and V edges noise generation\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($nsv>0)\r\n"
		+ "\t{\r\n"
		+ "\t$nsou=($nsv*$uev)*noise((($uvu*$nsr)+($uvv*(1-$nsr)))*\r\n"
		+ "\t(($nsf+0.05)*500));\r\n"
		+ "\r\n"
		+ "\t$nsov=($nsv*$vev)*noise((($uvu*(1-$nsr))+($uvv*$nsr))*\r\n"
		+ "\t(($nsf+0.05)*500));\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Reading temporal U and V values\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "\t$uvu=$uvut;\r\n"
		+ "\t$uvv=$uvvt;\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// U and V edges grain\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($rb>0)\r\n"
		+ "\t{\r\n"
		+ "\t$rc3=$gi*($rb*0.5*(noise($uvv*$uvu*20000)+1));\r\n"
		+ "\t$rc4=$go*($rb*0.5*(noise($uvv*$uvu*20000)+1));\r\n"
		+ "\t}\r\n"
		+ "else\r\n"
		+ "\t{\r\n"
		+ "\t$rc3=0;\r\n"
		+ "\t$rc4=0;\r\n"
		+ "\t}\r\n"
		+ "\t\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// U and V edges length\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($uec>0)\r\n"
		+ "\t{\r\n"
		+ "\t$edu=$uvu*(1/$uec)-((1/$uec)-(1/($uec*2))-0.5);\r\n"
		+ "\t}\r\n"
		+ "else\r\n"
		+ "\t{\r\n"
		+ "\t$uev=0;\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($vec>0)\r\n"
		+ "\t{\r\n"
		+ "\t$edv=$uvv*(1/$vec)-((1/$vec)-(1/($vec*2))-0.5);\r\n"
		+ "\t}\r\n"
		+ "else\r\n"
		+ "\t{\r\n"
		+ "\t$vev=0;\r\n"
		+ "\t}\r\n"
		+ "\t\r\n"
		+ "if ($edv<0 || $edv>1)\r\n"
		+ "\t{\r\n"
		+ "\t$uev=0;\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($edu<0 || $edu>1)\r\n"
		+ "\t{\r\n"
		+ "\t$vev=0;\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// U and V edges noise gain\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "\t$uvug=$uev*0.5;\r\n"
		+ "\t$uvvg=$vev*0.5;\r\n"
		+ "\r\n"
		+ "if ($nsv>0)\r\n"
		+ "\t{\r\n"
		+ "\tif ($uev>0)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$uev=$uev-$nsou;\r\n"
		+ "\t\t$uev=$uev-$nsou;\r\n"
		+ "\t\t$ueo=$ueo-$nsou;\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\tif ($vev>0)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$vev=$vev-$nsov;\r\n"
		+ "\t\t$vev=$vev-$nsov;\r\n"
		+ "\t\t$veo=$veo-$nsov;\r\n"
		+ "\t\t}\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// U and V edges fade\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($edv>=0 && $edv <0.5)\t\r\n"
		+ "\t{\r\n"
		+ "\t$x1=($edv*2); \r\n"
		+ "\t$y1=((1-pow(1-$x1,3))*$smf)+($x1*(1-$smf));\r\n"
		+ "\t$y1=$y1*$uef+(1*(1-$uef)); \r\n"
		+ "\tif ($fse==0) \r\n"
		+ "\t\t{\r\n"
		+ "\t\t$y1=1;\r\n"
		+ "\t\t}\r\n"
		+ "\t$uev=$uev*$y1;\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($edv>0.5 && $edv <=1)\r\n"
		+ "\t{\r\n"
		+ "\t$x1=1-(($edv-0.5)*2);\r\n"
		+ "\t$y1=((1-pow(1-$x1,3))*$smf)+($x1*(1-$smf)); \r\n"
		+ "\t$y1=$y1*$uef+(1*(1-$uef));\r\n"
		+ "\tif ($fee==0) \r\n"
		+ "\t\t{\r\n"
		+ "\t\t$y1=1;\r\n"
		+ "\t\t}\r\n"
		+ "\t$uev=$uev*$y1;\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($edu>=0 && $edu <0.5)\t\r\n"
		+ "\t{\r\n"
		+ "\t$x2=$edu*2; \r\n"
		+ "\t$y2=((1-pow(1-$x2,3))*$smf)+($x2*(1-$smf));\r\n"
		+ "\t$y2=$y2*$vef+(1*(1-$vef));\r\n"
		+ "\tif ($fse==0) \r\n"
		+ "\t\t{\r\n"
		+ "\t\t$y2=1;\r\n"
		+ "\t\t}\r\n"
		+ "\t$vev=$vev*$y2;\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($edu>0.5 && $edu <=1)\r\n"
		+ "\t{\r\n"
		+ "\t$x2=1-(($edu-0.5)*2); $y2=((1-pow(1-$x2,3))*$smf)+($x2*(1-$smf)); \r\n"
		+ "\t$y2=$y2*$vef+(1*(1-$vef));\r\n"
		+ "\tif ($fee==0)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$y2=1;\r\n"
		+ "\t\t}\r\n"
		+ "\t$vev=$vev*$y2;\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// U and V edges bias\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($ueb>0.5 && $uvu>0.5 && $uvu<=1)\r\n"
		+ "\t{\r\n"
		+ "\t$uev=$uev*(1-(($ueb-0.5)*2));\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($ueb<0.5 && $uvu>=0 && $uvu<0.5)\r\n"
		+ "\t{\r\n"
		+ "\t$uev=$uev*($ueb*2);\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($veb>0.5 && $uvv>0.5 && $uvv<=1)\r\n"
		+ "\t{\r\n"
		+ "\t$vev=$vev*(1-(($veb-0.5)*2));\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($veb<0.5 && $uvv>=0 && $uvv<0.5)\r\n"
		+ "\t{\r\n"
		+ "\t$vev=$vev*($veb*2);\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// U and V edges offset gain + blend gain\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "\t$ueo=$ueo*0.5;\r\n"
		+ "\t$veo=$veo*0.5;\r\n"
		+ "\t$gdu=$gdu*0.5;\r\n"
		+ "\t$gdv=$gdv*0.5;\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// U and V edges side control\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($bds==0)\r\n"
		+ "\t{\r\n"
		+ "\tif ($rbs==1)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$uev=$uev*$fpn;\r\n"
		+ "\t\t$vev=$vev*$fpn;\r\n"
		+ "\t\t}\r\n"
		+ "\telse\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$uev=$uev*(1-$fpn);\r\n"
		+ "\t\t$vev=$vev*(1-$fpn);\r\n"
		+ "\t\t}\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// U and V edges offset + grain + blend + transparency + draw + mask\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($uvu>=0+$ueo+($rc4*$uvug) && $uvu<$uev+$ueo-($rc3*$uvug))\t\r\n"
		+ "\t{\r\n"
		+ "\tif ($uvu<=($uev*$gdu)+$ueo && $bdo==1 && $gdu>0)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$ued=pow(($uvu-$ueo)*(1/($uev*$gdu)),$exp);\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\telse if ($uvu>=($uev*(1-$gdu))+$ueo && $bdi==1 && $gdu>0)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$ued=pow(1-(($uvu-($uev*(1-$gdu))-$ueo))*\r\n"
		+ "\t\t(1/($uev*$gdu)),$exp);\r\n"
		+ "\t\t}\r\n"
		+ "\telse\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$ued=1;\r\n"
		+ "\t\t}\r\n"
		+ "\t\r\n"
		+ "\tif ($adt==1)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$cbu0=$cbu0*(1-$uet)+$o0*$uet;\r\n"
		+ "\t\t$cbu1=$cbu1*(1-$uet)+$o1*$uet;\r\n"
		+ "\t\t$cbu2=$cbu2*(1-$uet)+$o2*$uet;\r\n"
		+ "\r\n"
		+ "\t\t$cmu0=$cmu0*(1-$uet)+$om0*$uet;\r\n"
		+ "\t\t$cmu1=$cmu1*(1-$uet)+$om1*$uet;\r\n"
		+ "\t\t$cmu2=$cmu2*(1-$uet)+$om2*$uet;\r\n"
		+ "\t\t}\r\n"
		+ "\telse\r\n"
		+ "\t\t{\r\n"
		+ "\t\tif ($vet>$uet)\r\n"
		+ "\t\t\t{\r\n"
		+ "\t\t\t$cbv0=$cbu0*$ued+$cbv0*(1-$ued);\r\n"
		+ "\t\t\t$cbv1=$cbu1*$ued+$cbv1*(1-$ued);\r\n"
		+ "\t\t\t$cbv2=$cbu2*$ued+$cbv2*(1-$ued);\r\n"
		+ "\r\n"
		+ "\t\t\t$cmv0=$cmu0*$ued+$cmv0*(1-$ued);\r\n"
		+ "\t\t\t$cmv1=$cmu1*$ued+$cmv1*(1-$ued);\r\n"
		+ "\t\t\t$cmv2=$cmu2*$ued+$cmv2*(1-$ued);\r\n"
		+ "\t\t\t}\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\t$o0=$o0*(1-$ued)+$cbu0*$ued;\r\n"
		+ "\t$o1=$o1*(1-$ued)+$cbu1*$ued;\r\n"
		+ "\t$o2=$o2*(1-$ued)+$cbu2*$ued;\r\n"
		+ "\r\n"
		+ "\t$om0=$om0*(1-$ued)+$cmu0*$ued;\r\n"
		+ "\t$om1=$om1*(1-$ued)+$cmu1*$ued;\r\n"
		+ "\t$om2=$om2*(1-$ued)+$cmu2*$ued;\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($uvu>(1-$uev)-$ueo+($rc3*$uvug) && $uvu<=1-$ueo-($rc4*$uvug))\t\r\n"
		+ "\t{\r\n"
		+ "\tif ($uvu<1-($ueo+($uev*(1-$gdu))) && $bdi==1 && $gdu>0)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$ued=pow(($uvu-(1-($ueo+$uev)))*(1/($uev*$gdu)),$exp);\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\telse if ($uvu>1-($ueo+($uev*$gdu)) && $bdo==1 && $gdu>0)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$ued=pow(1-(($uvu-(1-($ueo+($uev*$gdu))))*\r\n"
		+ "\t\t(1/($uev*$gdu))),$exp);\r\n"
		+ "\t\t}\r\n"
		+ "\telse\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$ued=1;\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\tif ($adt==1)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$cbu0=$cbu0*(1-$uet)+$o0*$uet;\r\n"
		+ "\t\t$cbu1=$cbu1*(1-$uet)+$o1*$uet;\r\n"
		+ "\t\t$cbu2=$cbu2*(1-$uet)+$o2*$uet;\r\n"
		+ "\r\n"
		+ "\t\t$cmu0=$cmu0*(1-$uet)+$om0*$uet;\r\n"
		+ "\t\t$cmu1=$cmu1*(1-$uet)+$om1*$uet;\r\n"
		+ "\t\t$cmu2=$cmu2*(1-$uet)+$om2*$uet;\r\n"
		+ "\t\t}\r\n"
		+ "\telse\r\n"
		+ "\t\t{\r\n"
		+ "\t\tif ($vet>$uet)\r\n"
		+ "\t\t\t{\r\n"
		+ "\t\t\t$cbv0=$cbu0*$ued+$cbv0*(1-$ued);\r\n"
		+ "\t\t\t$cbv1=$cbu1*$ued+$cbv1*(1-$ued);\r\n"
		+ "\t\t\t$cbv2=$cbu2*$ued+$cbv2*(1-$ued);\r\n"
		+ "\r\n"
		+ "\t\t\t$cmv0=$cmu0*$ued+$cmv0*(1-$ued);\r\n"
		+ "\t\t\t$cmv1=$cmu1*$ued+$cmv1*(1-$ued);\r\n"
		+ "\t\t\t$cmv2=$cmu2*$ued+$cmv2*(1-$ued);\r\n"
		+ "\t\t\t}\r\n"
		+ "\t\t}\r\n"
		+ "\t\r\n"
		+ "\t$o0=$o0*(1-$ued)+$cbu0*$ued;\r\n"
		+ "\t$o1=$o1*(1-$ued)+$cbu1*$ued;\r\n"
		+ "\t$o2=$o2*(1-$ued)+$cbu2*$ued;\r\n"
		+ "\r\n"
		+ "\t$om0=$om0*(1-$ued)+$cmu0*$ued;\r\n"
		+ "\t$om1=$om1*(1-$ued)+$cmu1*$ued;\r\n"
		+ "\t$om2=$om2*(1-$ued)+$cmu2*$ued;\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($uvv>=0+$veo+($rc4*$uvvg) && $uvv<$vev+$veo-($rc3*$uvvg))\t\r\n"
		+ "\t{\r\n"
		+ "\tif ($uvv<($vev*$gdv)+$veo && $bdo==1 && $gdv>0)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$ved=pow(($uvv-$veo)*(1/($vev*$gdv)),$exp);\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\telse if ($uvv>($vev*(1-$gdv))+$veo && $bdi==1 && $gdv>0)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$ved=pow(1-(($uvv-($vev*(1-$gdv))-$veo))*\r\n"
		+ "\t\t(1/($vev*$gdv)),$exp);\r\n"
		+ "\t\t}\r\n"
		+ "\telse\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$ved=1;\r\n"
		+ "\t\t}\r\n"
		+ "\t\r\n"
		+ "\tif ($adt==1)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$cbv0=$cbv0*(1-$vet)+$o0*$vet;\r\n"
		+ "\t\t$cbv1=$cbv1*(1-$vet)+$o1*$vet;\r\n"
		+ "\t\t$cbv2=$cbv2*(1-$vet)+$o2*$vet;\r\n"
		+ "\r\n"
		+ "\t\t$cmv0=$cmv0*(1-$vet)+$om0*$vet;\r\n"
		+ "\t\t$cmv1=$cmv1*(1-$vet)+$om1*$vet;\r\n"
		+ "\t\t$cmv2=$cmv2*(1-$vet)+$om2*$vet;\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\t$o0=$o0*(1-$ved)+$cbv0*$ved;\r\n"
		+ "\t$o1=$o1*(1-$ved)+$cbv1*$ved;\r\n"
		+ "\t$o2=$o2*(1-$ved)+$cbv2*$ved;\r\n"
		+ "\r\n"
		+ "\t$om0=$om0*(1-$ved)+$cmv0*$ved;\r\n"
		+ "\t$om1=$om1*(1-$ved)+$cmv1*$ved;\r\n"
		+ "\t$om2=$om2*(1-$ved)+$cmv2*$ved;\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($uvv>(1-$vev)-$veo+($rc3*$uvvg) && $uvv<=1-$veo-($rc4*$uvvg))\t\r\n"
		+ "\t{\r\n"
		+ "\tif ($uvv<1-($veo+($vev*(1-$gdv))) && $bdi==1 && $gdv>0)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$ved=pow(($uvv-(1-($veo+$vev)))*(1/($vev*$gdv)),$exp);\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\telse if ($uvv>1-($veo+($vev*$gdv)) && $bdo==1 && $gdv>0)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$ved=pow(1-(($uvv-(1-($veo+($vev*$gdv))))*\r\n"
		+ "\t\t(1/($vev*$gdv))),$exp);\r\n"
		+ "\t\t}\r\n"
		+ "\telse\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$ved=1;\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\tif ($adt==1)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$cbv0=$cbv0*(1-$vet)+$o0*$vet;\r\n"
		+ "\t\t$cbv1=$cbv1*(1-$vet)+$o1*$vet;\r\n"
		+ "\t\t$cbv2=$cbv2*(1-$vet)+$o2*$vet;\r\n"
		+ "\r\n"
		+ "\t\t$cmv0=$cmv0*(1-$vet)+$om0*$vet;\r\n"
		+ "\t\t$cmv1=$cmv1*(1-$vet)+$om1*$vet;\r\n"
		+ "\t\t$cmv2=$cmv2*(1-$vet)+$om2*$vet;\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\t$o0=$o0*(1-$ved)+$cbv0*$ved;\r\n"
		+ "\t$o1=$o1*(1-$ved)+$cbv1*$ved;\r\n"
		+ "\t$o2=$o2*(1-$ved)+$cbv2*$ved;\r\n"
		+ "\r\n"
		+ "\t$om0=$om0*(1-$ved)+$cmv0*$ved;\r\n"
		+ "\t$om1=$om1*(1-$ved)+$cmv1*$ved;\r\n"
		+ "\t$om2=$om2*(1-$ved)+$cmv2*$ved;\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Postprocess ( With borders )\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// RGB -> HSV conversion\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($ppb==1)\r\n"
		+ "\t{\r\n"
		+ "\t$a=<<$o0,$o1,$o2>>;\r\n"
		+ "\r\n"
		+ "\t$b=rgb_to_hsv($a);\r\n"
		+ "\r\n"
		+ "\t$b0=$b * <<1,0,0>>;\r\n"
		+ "\t$b1=$b * <<0,1,0>>;\r\n"
		+ "\t$b2=$b * <<0,0,1>>;\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Postprocess / saturation\r\n"
		+ " \r\n"
		+ "\r\n"
		+ "if ($ppb==1 && $ds>0)\r\n"
		+ "\t{\r\n"
		+ "\tif ($b1>0.5)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$b1=1-0.5*pow(2*(1-$b1),pow($ds+1,3));\r\n"
		+ "\t\t}\r\n"
		+ "\tif ($b2>0.5)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$b2=1-0.5*pow(2*(1-$b2),pow($ds+1,3));\r\n"
		+ "\t\t}\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "if ($ppb==1 && $ds<0)\r\n"
		+ "\t{\r\n"
		+ "\t$b1=$b1+$ds;\r\n"
		+ "\t$b1=clamp(0,1,$b1);\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Postprocess / soft colors\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($ppb==1 && $ap==1)\r\n"
		+ "\t{\r\n"
		+ "\t$b1=clamp(0,0.5,$b1);\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// HSV -> RGB conversion\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($ppb==1)\r\n"
		+ "\t{\r\n"
		+ "\t$b=<<$b0,$b1,$b2>>;\r\n"
		+ "\r\n"
		+ "\t$O=hsv_to_rgb($b);\r\n"
		+ "\t\r\n"
		+ "\t$o0=$O * <<1,0,0>>;\r\n"
		+ "\t$o1=$O * <<0,1,0>>;\r\n"
		+ "\t$o2=$O * <<0,0,1>>;\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Postprocess / brightness\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($ppb==1 && $bgt!=0)\r\n"
		+ "\t{\r\n"
		+ "\t$o0=$o0+($bgt*0.5);\r\n"
		+ "\t$o1=$o1+($bgt*0.5);\r\n"
		+ "\t$o2=$o2+($bgt*0.5);\r\n"
		+ "\r\n"
		+ "\t$o0=clamp(0,1,$o0);\r\n"
		+ "\t$o1=clamp(0,1,$o1);\r\n"
		+ "\t$o2=clamp(0,1,$o2);\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Postprocess / contrast\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($ppb==1 && $ctr!=0)\r\n"
		+ "\t{\r\n"
		+ "\tif ($o0<0.5) \r\n"
		+ "\t\t{\r\n"
		+ "\t\t$o0=0.5*pow(2*$o0,pow($ctr+1,2)); \r\n"
		+ "\t\t}\r\n"
		+ "\telse \r\n"
		+ "\t\t{\r\n"
		+ "\t\t$o0=1-0.5*pow(2*(1-$o0),pow($ctr+1,2));\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\tif ($o1<0.5)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$o1=0.5*pow(2*$o1,pow($ctr+1,2));\r\n"
		+ "\t\t}\r\n"
		+ "\telse\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$o1=1-0.5*pow(2*(1-$o1),pow($ctr+1,2));\r\n"
		+ "\t\t}\r\n"
		+ "\r\n"
		+ "\tif ($o2<0.5)\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$o2=0.5*pow(2*$o2,pow($ctr+1,2));\r\n"
		+ "\t\t}\r\n"
		+ "\telse\r\n"
		+ "\t\t{\r\n"
		+ "\t\t$o2=1-0.5*pow(2*(1-$o2),pow($ctr+1,2)); \r\n"
		+ "\t\t}\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Mask type + gain\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "if ($opm==0)\r\n"
		+ "\t{\r\n"
		+ "\t$om0=1;\r\n"
		+ "\t$om1=1;\r\n"
		+ "\t$om2=1;\r\n"
		+ "\t}\r\n"
		+ "\r\n"
		+ "\t$om0=$om0*$omg;\r\n"
		+ "\t$om1=$om1*$omg;\r\n"
		+ "\t$om2=$om2*$omg;\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// End process\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// Links Out\r\n"
		+ "//\r\n"
		+ "\r\n"
		+ ".O[0]=\t\t$o0;\r\n"
		+ ".O[1]=\t\t$o1;\r\n"
		+ ".O[2]=\t\t$o2;\r\n"
		+ ".O[3]= \t$om0;\r\n"
		+ ".O[4]= \t$om1;\r\n"
		+ ".O[5]= \t$om2;\r\n"
		+ "\r\n"
		+ "// -------------------------------------------------------------\r\n"
		+ "// End expression\r\n"
		+ "//\r\n"
		+ "\r");
	setAttr ".ani" no;
createNode samplerInfo -n "imageData_3";
createNode lambert -n "input_3";
	setAttr ".dc" 1;
	setAttr ".c" -type "float3" 0.98000002 0.66492999 0 ;
createNode surfaceShader -n "denfo_";
	addAttr -ci true -sn "cSteps" -ln "colorSteps" -min 0 -max 128 -at "long";
	addAttr -ci true -sn "lSteps" -ln "luminanceSteps" -min 0 -max 64 -at "long";
	addAttr -ci true -sn "bColorR" -ln "borderColorR" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "bColorG" -ln "borderColorG" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "bColorB" -ln "borderColorB" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "bThick" -ln "borderThickness" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "eFVisib" -ln "facingEdgeVisibility" -min 0 -max 1 
		-at "double";
	addAttr -ci true -sn "eUVisib" -ln "uEdgeVisibility" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "eVVisib" -ln "vEdgeVisibility" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "bDSide" -ln "doubleSidedBorder" -min 0 -max 1 -at "bool";
	addAttr -ci true -sn "bRSide" -ln "opposite" -min 0 -max 1 -at "bool";
	addAttr -ci true -sn "uELength" -ln "uEdgeLength" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "vELength" -ln "vEdgeLength" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "fEOffset" -ln "facingEdgeOffset" -min -1 -max 1 -at "double";
	addAttr -ci true -sn "uEOffset" -ln "uEdgeOffset" -min -1 -max 1 -at "double";
	addAttr -ci true -sn "vEOffset" -ln "vEdgeOffset" -min -1 -max 1 -at "double";
	addAttr -ci true -sn "cBias" -ln "colorBias" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "lBias" -ln "luminanceBias" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "fEBias" -ln "facingEdgeBias" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "uEBias" -ln "uEdgeBias" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "vEBias" -ln "vEdgeBias" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "uEFade" -ln "uEdgeFade" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "vEFade" -ln "vEdgeFade" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "fEStart" -ln "fadeEdgeStart" -min 0 -max 1 -at "bool";
	addAttr -ci true -sn "fEEnd" -ln "fadeEdgeEnd" -min 0 -max 1 -at "bool";
	addAttr -ci true -sn "eFSmooth" -ln "smoothFade" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "fETransp" -ln "facingEdgeTransp" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "uETransp" -ln "uEdgeTransp" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "vETransp" -ln "vEdgeTransp" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "aETransp" -ln "additiveTransp" -min 0 -max 1 -at "bool";
	addAttr -ci true -sn "cNoise" -ln "colorNoise" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "lNoise" -ln "luminanceNoise" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "bNoise" -ln "borderNoise" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "noiseF" -ln "noiseFrequency" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "rotAng" -ln "rotateAngle" -min 0 -max 180 -at "double";
	addAttr -ci true -sn "cGrain" -ln "colorGrain" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "lGrain" -ln "luminanceGrain" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "bGrain" -ln "borderGrain" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "bGrainIn" -ln "borderGrainIn" -min 0 -max 1 -at "bool";
	addAttr -ci true -sn "bGrainOut" -ln "borderGrainOut" -min 0 -max 1 -at "bool";
	addAttr -ci true -sn "cBlend" -ln "colorBlend" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "lBlend" -ln "luminanceBlend" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "bBlend" -ln "borderBlend" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "bBlendIn" -ln "borderBlendIn" -min 0 -max 1 -at "bool";
	addAttr -ci true -sn "bBlendOut" -ln "borderBlendOut" -min 0 -max 1 -at "bool";
	addAttr -ci true -sn "sat" -ln "saturation" -min -1 -max 1 -at "double";
	addAttr -ci true -sn "bright" -ln "brightness" -min -1 -max 1 -at "double";
	addAttr -ci true -sn "contr" -ln "contrast" -min -1 -max 1 -at "double";
	addAttr -ci true -sn "softC" -ln "softColors" -min 0 -max 1 -at "bool";
	addAttr -ci true -sn "postPB" -ln "postProcessBorder" -min 0 -max 1 -at "bool";
	addAttr -ci true -sn "mGain" -ln "maskGain" -min 0 -max 1 -at "double";
	addAttr -ci true -sn "oGMask" -ln "opacityGainMask" -min 0 -max 1 -at "bool";
	setAttr -k on ".cSteps" 28;
	setAttr -k on ".lSteps" 4;
	setAttr -k on ".bColorR" 1;
	setAttr -k on ".bColorG" 1;
	setAttr -k on ".bColorB" 1;
	setAttr -k on ".bThick" 0.5;
	setAttr -k on ".eFVisib" 1;
	setAttr -k on ".eUVisib";
	setAttr -k on ".eVVisib";
	setAttr -k on ".bDSide" yes;
	setAttr -k on ".bRSide";
	setAttr -k on ".uELength" 1;
	setAttr -k on ".vELength" 1;
	setAttr -k on ".fEOffset" 0.0070000000000000001;
	setAttr -k on ".uEOffset";
	setAttr -k on ".vEOffset";
	setAttr -k on ".cBias" 0.504;
	setAttr -k on ".lBias" 0.5;
	setAttr -k on ".fEBias" 0.5;
	setAttr -k on ".uEBias" 0.504;
	setAttr -k on ".vEBias" 0.5;
	setAttr -k on ".uEFade";
	setAttr -k on ".vEFade";
	setAttr -k on ".fEStart" yes;
	setAttr -k on ".fEEnd" yes;
	setAttr -k on ".eFSmooth";
	setAttr -k on ".fETransp";
	setAttr -k on ".uETransp";
	setAttr -k on ".vETransp";
	setAttr -k on ".aETransp" yes;
	setAttr -k on ".cNoise" 0.504;
	setAttr -k on ".lNoise";
	setAttr -k on ".bNoise" 0.53900000000000003;
	setAttr -k on ".noiseF" 0.617;
	setAttr -k on ".rotAng";
	setAttr -k on ".cGrain" 0.518;
	setAttr -k on ".lGrain";
	setAttr -k on ".bGrain";
	setAttr -k on ".bGrainIn" yes;
	setAttr -k on ".bGrainOut";
	setAttr -k on ".cBlend" 0.567;
	setAttr -k on ".lBlend" 0.6;
	setAttr -k on ".bBlend" 0.5;
	setAttr -k on ".bBlendIn" yes;
	setAttr -k on ".bBlendOut" yes;
	setAttr -k on ".sat" 0.362;
	setAttr -k on ".bright" -0.078;
	setAttr -k on ".contr" -0.0070000000000000001;
	setAttr -k on ".softC";
	setAttr -k on ".postPB" yes;
	setAttr -k on ".mGain" 1;
	setAttr -k on ".oGMask" yes;
createNode lightLinker -n "lightLinker1";
	setAttr ".ihi" 0;
	setAttr -s 13 ".lnk";
select -ne :time1;
	setAttr ".o" 0;
select -ne :renderPartition;
	setAttr -s 13 ".st";
select -ne :renderGlobalsList1;
select -ne :defaultShaderList1;
	setAttr -s 10 ".s";
select -ne :postProcessList1;
	setAttr -s 2 ".p";
select -ne :defaultRenderUtilityList1;
	setAttr -s 28 ".u";
select -ne :lightList1;
	setAttr -s 2 ".l";
select -ne :defaultTextureList1;
select -ne :initialShadingGroup;
	setAttr ".ro" yes;
select -ne :initialParticleSE;
	setAttr ".ro" yes;
select -ne :defaultRenderGlobals;
	setAttr ".outf" 19;
	setAttr ".top" 479;
	setAttr ".rght" 639;
select -ne :defaultRenderQuality;
	setAttr ".rfl" 4;
	setAttr ".rfr" 4;
	setAttr ".sl" 4;
	setAttr ".eaa" 0;
	setAttr ".ufil" yes;
	setAttr ".ss" 2;
	setAttr ".rct" 0.20000000298023224;
	setAttr ".gct" 0.15000000596046448;
	setAttr ".bct" 0.30000001192092896;
select -ne :defaultResolution;
	setAttr ".w" 640;
	setAttr ".h" 480;
	setAttr ".dar" 1.3329999446868896;
	setAttr ".ldar" yes;
select -ne :defaultLightSet;
	setAttr -s 2 ".dsm";
select -ne :hyperGraphLayout;
	setAttr ".cch" no;
	setAttr ".ihi" 2;
	setAttr ".nds" 0;
	setAttr ".img" -type "string" "";
	setAttr ".ims" 1;
connectAttr "imageData_3.u" "cellExpression_3.in[0]";
connectAttr "imageData_3.v" "cellExpression_3.in[1]";
connectAttr "imageData_3.fn" "cellExpression_3.in[2]";
connectAttr "imageData_3.fr" "cellExpression_3.in[3]";
connectAttr "input_3.ocr" "cellExpression_3.in[4]";
connectAttr "input_3.ocg" "cellExpression_3.in[5]";
connectAttr "input_3.ocb" "cellExpression_3.in[6]";
connectAttr "input_3.omor" "cellExpression_3.in[7]";
connectAttr "input_3.omog" "cellExpression_3.in[8]";
connectAttr "input_3.omob" "cellExpression_3.in[9]";
connectAttr "denfo_.cSteps" "cellExpression_3.in[10]";
connectAttr "denfo_.lSteps" "cellExpression_3.in[11]";
connectAttr "denfo_.bColorR" "cellExpression_3.in[12]";
connectAttr "denfo_.bColorG" "cellExpression_3.in[13]";
connectAttr "denfo_.bColorB" "cellExpression_3.in[14]";
connectAttr "denfo_.bThick" "cellExpression_3.in[15]";
connectAttr "denfo_.eFVisib" "cellExpression_3.in[16]";
connectAttr "denfo_.eUVisib" "cellExpression_3.in[17]";
connectAttr "denfo_.eVVisib" "cellExpression_3.in[18]";
connectAttr "denfo_.bDSide" "cellExpression_3.in[19]";
connectAttr "denfo_.bRSide" "cellExpression_3.in[20]";
connectAttr "denfo_.uELength" "cellExpression_3.in[21]";
connectAttr "denfo_.vELength" "cellExpression_3.in[22]";
connectAttr "denfo_.fEOffset" "cellExpression_3.in[23]";
connectAttr "denfo_.uEOffset" "cellExpression_3.in[24]";
connectAttr "denfo_.vEOffset" "cellExpression_3.in[25]";
connectAttr "denfo_.cBias" "cellExpression_3.in[26]";
connectAttr "denfo_.lBias" "cellExpression_3.in[27]";
connectAttr "denfo_.fEBias" "cellExpression_3.in[28]";
connectAttr "denfo_.uEBias" "cellExpression_3.in[29]";
connectAttr "denfo_.vEBias" "cellExpression_3.in[30]";
connectAttr "denfo_.uEFade" "cellExpression_3.in[31]";
connectAttr "denfo_.vEFade" "cellExpression_3.in[32]";
connectAttr "denfo_.eFSmooth" "cellExpression_3.in[33]";
connectAttr "denfo_.fEStart" "cellExpression_3.in[34]";
connectAttr "denfo_.fEEnd" "cellExpression_3.in[35]";
connectAttr "denfo_.fETransp" "cellExpression_3.in[36]";
connectAttr "denfo_.uETransp" "cellExpression_3.in[37]";
connectAttr "denfo_.vETransp" "cellExpression_3.in[38]";
connectAttr "denfo_.aETransp" "cellExpression_3.in[39]";
connectAttr "denfo_.cNoise" "cellExpression_3.in[40]";
connectAttr "denfo_.lNoise" "cellExpression_3.in[41]";
connectAttr "denfo_.bNoise" "cellExpression_3.in[42]";
connectAttr "denfo_.noiseF" "cellExpression_3.in[43]";
connectAttr "denfo_.rotAng" "cellExpression_3.in[44]";
connectAttr "denfo_.cGrain" "cellExpression_3.in[45]";
connectAttr "denfo_.lGrain" "cellExpression_3.in[46]";
connectAttr "denfo_.bGrain" "cellExpression_3.in[47]";
connectAttr "denfo_.bGrainIn" "cellExpression_3.in[48]";
connectAttr "denfo_.bGrainOut" "cellExpression_3.in[49]";
connectAttr "denfo_.cBlend" "cellExpression_3.in[50]";
connectAttr "denfo_.lBlend" "cellExpression_3.in[51]";
connectAttr "denfo_.bBlend" "cellExpression_3.in[52]";
connectAttr "denfo_.bBlendIn" "cellExpression_3.in[53]";
connectAttr "denfo_.bBlendOut" "cellExpression_3.in[54]";
connectAttr "denfo_.sat" "cellExpression_3.in[55]";
connectAttr "denfo_.bright" "cellExpression_3.in[56]";
connectAttr "denfo_.contr" "cellExpression_3.in[57]";
connectAttr "denfo_.softC" "cellExpression_3.in[58]";
connectAttr "denfo_.postPB" "cellExpression_3.in[59]";
connectAttr "denfo_.mGain" "cellExpression_3.in[60]";
connectAttr "denfo_.oGMask" "cellExpression_3.in[61]";
connectAttr "cellExpression_3.out[0]" "denfo_.ocr";
connectAttr "cellExpression_3.out[1]" "denfo_.ocg";
connectAttr "cellExpression_3.out[2]" "denfo_.ocb";
connectAttr "cellExpression_3.out[3]" "denfo_.omor";
connectAttr "cellExpression_3.out[4]" "denfo_.omog";
connectAttr "cellExpression_3.out[5]" "denfo_.omob";
connectAttr ":defaultLightSet.msg" "lightLinker1.lnk[0].llnk";
connectAttr ":initialShadingGroup.msg" "lightLinker1.lnk[0].olnk";
connectAttr ":defaultLightSet.msg" "lightLinker1.lnk[1].llnk";
connectAttr ":initialParticleSE.msg" "lightLinker1.lnk[1].olnk";
connectAttr ":defaultLightSet.msg" "lightLinker1.lnk[2].llnk";
connectAttr ":defaultLightSet.msg" "lightLinker1.lnk[3].llnk";
connectAttr ":defaultLightSet.msg" "lightLinker1.lnk[4].llnk";
connectAttr ":defaultLightSet.msg" "lightLinker1.lnk[5].llnk";
connectAttr ":defaultLightSet.msg" "lightLinker1.lnk[6].llnk";
connectAttr ":defaultLightSet.msg" "lightLinker1.lnk[7].llnk";
connectAttr ":defaultLightSet.msg" "lightLinker1.lnk[8].llnk";
connectAttr ":defaultLightSet.msg" "lightLinker1.lnk[9].llnk";
connectAttr ":defaultLightSet.msg" "lightLinker1.lnk[10].llnk";
connectAttr ":defaultLightSet.msg" "lightLinker1.lnk[11].llnk";
connectAttr ":defaultLightSet.msg" "lightLinker1.lnk[12].llnk";
connectAttr "denfo_.msg" ":defaultShaderList1.s" -na;
connectAttr "input_3.msg" ":defaultShaderList1.s" -na;
connectAttr "imageData_3.msg" ":defaultRenderUtilityList1.u" -na;
connectAttr "lightLinker1.msg" ":lightList1.ln" -na;
// End of denfo-07.ma
